using System;

public delegate void OnPrzypisanieEventDelegate(Kontener obj);

public class Kontener
{
  private int x;
  public event OnPrzypisanieEventDelegate OnUjemne;
  public event OnPrzypisanieEventDelegate OnDodatnie;
  public event OnPrzypisanieEventDelegate OnZero;
  public int getX()
  {
    return x;
  }
  public void setX(int arg)
  {
    x = arg;
    if(arg < 0)
    {
      if(OnUjemne != null)
      {
        OnUjemne(this);
      }
    }
    else if(arg > 0)
    {
      if(OnDodatnie != null)
      {
        OnDodatnie(this);
      }
    }
    else
    {
      if(OnZero != null)
      {
        OnZero(this);
      }
    }
  }
}

public class Program
{
  public static void OnUjemneKomunikat(Kontener obj)
  {
    Console.WriteLine("Przypisano ujemn warto = {0}.", obj.getX());
  }
  public static void OnDodatnieKomunikat(Kontener obj)
  {
    Console.WriteLine("Przypisano dodatni warto = {0}.", obj.getX());
  }
  public static void OnZeroKomunikat(Kontener obj)
  {
    Console.WriteLine("Przypisano dodatni warto = 0.");
  }
  public static void Main()
  {
    Kontener k = new Kontener();
    k.OnUjemne += OnUjemneKomunikat;
    k.OnDodatnie += OnDodatnieKomunikat;
    k.OnZero += OnZeroKomunikat;

    k.setX(10);
    k.setX(0);
    k.setX(-10);
  }
}
